//+------------------------------------------------------------------+
//|                                                 C_HLineTrade.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include <NanoEA-SIMD\Auxiliar\C_Terminal.mqh>
//+------------------------------------------------------------------+
class C_HLineTrade
{
#define def_NameHLineTrade "*HLTSMD*"
	protected:
		enum eHLineTrade {HL_PRICE, HL_STOP, HL_TAKE};
	private	:
		color		m_corPrice,
					m_corStop,
					m_corTake;
		string	m_SelectObj;
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_HLineTrade() : m_SelectObj("")
			{
				ChartSetInteger(Terminal.Get_ID(), CHART_SHOW_TRADE_LEVELS, false);
				RemoveAllsLines();
			};
//+------------------------------------------------------------------+	
		~C_HLineTrade()
			{
				RemoveAllsLines();
				ChartSetInteger(Terminal.Get_ID(), CHART_SHOW_TRADE_LEVELS, true);
			};
//+------------------------------------------------------------------+
		void SetDefaultColors(color c1, color c2, color c3)
			{
				m_corPrice = c1;
				m_corTake = c2;
				m_corStop = c3;
			}
//+------------------------------------------------------------------+
		void RemoveAllsLines(void)
			{
				string sz0;
				int i0 = StringLen(def_NameHLineTrade);
				
				for (int c0 = ObjectsTotal(Terminal.Get_ID(), -1, -1); c0 >= 0; c0--)
				{
					sz0 = ObjectName(Terminal.Get_ID(), c0, -1, -1);
					if (StringSubstr(sz0, 0, i0) == def_NameHLineTrade) ObjectDelete(Terminal.Get_ID(), sz0);
				}
			}
//+------------------------------------------------------------------+
inline void SetLineOrder(ulong ticket, double price, eHLineTrade hl, bool select)
			{
				string sz0 = def_NameHLineTrade + (string)hl + (string)ticket, sz1;
				
				if (price <= 0)
				{
					ObjectDelete(Terminal.Get_ID(), sz0);
					return;
				}
				if (!ObjectGetString(Terminal.Get_ID(), sz0, OBJPROP_TOOLTIP, 0, sz1))
				{
					ObjectCreate(Terminal.Get_ID(), sz0, OBJ_HLINE, 0, 0, 0);
					ObjectSetInteger(Terminal.Get_ID(), sz0, OBJPROP_COLOR, (hl == HL_PRICE ? m_corPrice : (hl == HL_STOP ? m_corStop : m_corTake)));
					ObjectSetInteger(Terminal.Get_ID(), sz0, OBJPROP_WIDTH, 1);
					ObjectSetInteger(Terminal.Get_ID(), sz0, OBJPROP_STYLE, STYLE_DASHDOT);
					ObjectSetInteger(Terminal.Get_ID(), sz0, OBJPROP_SELECTABLE, select);
					ObjectSetInteger(Terminal.Get_ID(), sz0, OBJPROP_SELECTED, false);
					ObjectSetInteger(Terminal.Get_ID(), sz0, OBJPROP_BACK, true);
					ObjectSetString(Terminal.Get_ID(), sz0, OBJPROP_TOOLTIP, (string)ticket + " "+StringSubstr(EnumToString(hl), 3, 10));
				}
				ObjectSetDouble(Terminal.Get_ID(), sz0, OBJPROP_PRICE, price);
			}
//+------------------------------------------------------------------+
		bool GetNewInfosOrder(const string &sparam, ulong &ticket, double &price, eHLineTrade &hl)
			{
				int i0 = StringLen(def_NameHLineTrade);
				
				if (StringSubstr(sparam, 0, i0) == def_NameHLineTrade)
				{
					hl = (eHLineTrade) StringToInteger(StringSubstr(sparam, i0, 1));
					ticket = (ulong)StringToInteger(StringSubstr(sparam, i0 + 1, StringLen(sparam)));
					price = ObjectGetDouble(Terminal.Get_ID(), sparam, OBJPROP_PRICE);
					return true;
				}
				return false;
			}
//+------------------------------------------------------------------+	
inline void Select(const string &sparam)
			{
				int i0 = StringLen(def_NameHLineTrade);
				
				if (m_SelectObj != "")
				{
					ObjectSetInteger(Terminal.Get_ID(), m_SelectObj, OBJPROP_SELECTED, false);
					ObjectSetInteger(Terminal.Get_ID(), m_SelectObj, OBJPROP_WIDTH, 1);
				}
				m_SelectObj = "";
				if (StringSubstr(sparam, 0, i0) == def_NameHLineTrade)
				{
					if (ObjectGetInteger(Terminal.Get_ID(), sparam, OBJPROP_SELECTABLE))
					{
						ObjectSetInteger(Terminal.Get_ID(), sparam, OBJPROP_SELECTED, true);
						ObjectSetInteger(Terminal.Get_ID(), sparam, OBJPROP_WIDTH, 2);
						m_SelectObj = sparam;
					};
				}
			}
//+------------------------------------------------------------------+	
#undef def_NameHLineTrade
};
//+------------------------------------------------------------------+
